
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data representing scores for different sections of law exams in three categories
data_criminal_law = [
    np.random.normal(65, 5, 20),  # Section 1
    np.random.normal(68, 4, 20),  # Section 2
    np.random.normal(70, 3, 20)   # Section 3
]
data_civil_law = [
    np.random.normal(75, 3, 20),  # Section 1
    np.random.normal(80, 2, 20),  # Section 2
    np.random.normal(78, 3, 20)   # Section 3
]
data_corporate_law = [
    np.random.normal(85, 4, 20),  # Section 1
    np.random.normal(88, 2, 20),  # Section 2
    np.random.normal(87, 3, 20)   # Section 3
]

# Combine data
data = [data_criminal_law, data_civil_law, data_corporate_law]
xticklabels = ["Criminal Law", "Civil Law", "Corporate Law"]
ylabel = "Exam Scores"
xlabel = "Law Categories"
xticks = [1, 3, 5]
ylim = [50, 100]
title = "Scores in Different Law Exam Categories"
legend_labels = ["Section 1", "Section 2", "Section 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with specific size
fig, ax = plt.subplots(figsize=(7, 5))  # Adjusted size for better visibility

# Plot boxplots with different colors and hatch patterns
colors = ["#1f77b4", "#2ca02c", "#d62728"]  # Blue, Green, and Red
hatches = ["/", "\\", "o"]  # Diagonal, horizontal lines, and dots

for i, d in enumerate(data):
    bp = ax.boxplot(
        d,
        positions=np.array(range(len(d))) * 2 + (i + 1) * 0.5,
        widths=0.5,
        patch_artist=True,
    )
    for patch in bp["boxes"]:
        patch.set_facecolor(colors[i])
        patch.set_hatch(hatches[i])
        patch.set_edgecolor("black")
    for flier in bp["fliers"]:
        flier.set(
            marker="o", color="black", markerfacecolor="black", markersize=2, alpha=0.5
        )

# Customizing the plot
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_ylim(ylim)
ax.set_title(title)

# Adding legend manually
legend_elements = [
    Patch(facecolor=colors[0], hatch=hatches[0], label=legend_labels[0], edgecolor="black"),
    Patch(facecolor=colors[1], hatch=hatches[1], label=legend_labels[1], edgecolor="black"),
    Patch(facecolor=colors[2], hatch=hatches[2], label=legend_labels[2], edgecolor="black"),
]
ax.legend(handles=legend_elements, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_47.pdf", bbox_inches="tight")
