# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for demonstration purposes (Quarterly Crop Yield Over 3 Years in tons/hectare)
crop1 = [
    np.random.normal(3.5, 0.3, 12),
    np.random.normal(3.7, 0.3, 12),
    np.random.normal(3.6, 0.2, 12),
]
crop2 = [
    np.random.normal(4.2, 0.4, 12),
    np.random.normal(4.4, 0.3, 12),
    np.random.normal(4.3, 0.3, 12),
]
crop3 = [
    np.random.normal(2.8, 0.2, 12),
    np.random.normal(3.0, 0.2, 12),
    np.random.normal(2.9, 0.2, 12),
]

# Combine data
data = [crop1, crop2, crop3]
xticklabels = ["Year 1", "Year 2", "Year 3"]
ylabel = "Quarterly Crop Yield (tons/hectare)"
xticks = [1, 3, 5]
ylim = [2.0, 5.0]
labels = ["Wheat", "Corn", "Rice"]
title = "Quarterly Crop Yield Over 3 Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with specific size
fig, ax = plt.subplots(figsize=(7, 5))  # Slightly wider for better readability

# Plot boxplots with different colors and hatch patterns
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]  # Blue, Orange, Green
hatches = ["//", "\\\\", "||"]  # Diagonal lines, and vertical bars

for i, d in enumerate(data):
    bp = ax.boxplot(
        d,
        positions=np.array(range(len(d))) * 2 + (i + 1) * 0.5,
        widths=0.5,
        patch_artist=True,
    )
    for patch in bp["boxes"]:
        patch.set_facecolor(colors[i])
        patch.set_hatch(hatches[i])
        patch.set_edgecolor("black")  # Set edge color to black
    for flier in bp["fliers"]:
        flier.set(
            marker="o", color="black", markerfacecolor="black", markersize=2, alpha=0.5
        )

# Customizing the plot to match professional business visuals
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.set_title(title)

# Adding legend manually to match the business theme
legend_elements = [
    Patch(facecolor=colors[0], hatch=hatches[0], label=labels[0], edgecolor="black"),
    Patch(facecolor=colors[1], hatch=hatches[1], label=labels[1], edgecolor="black"),
    Patch(facecolor=colors[2], hatch=hatches[2], label=labels[2], edgecolor="black"),
]
ax.legend(handles=legend_elements, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_49.pdf", bbox_inches="tight")
