

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for the boxplots (representing visitors to art exhibitions over a week)
data1 = [120, 130, 125, 140, 135, 145, 150]  # Exhibition A
data2 = [80, 90, 85, 95, 100, 105, 110]     # Exhibition B
xticklabels = ["Exhibition A\n(Daily Visitors)", "Exhibition B\n(Daily Visitors)"]
ylabel = "Number of Visitors"
xlabel = "Exhibitions"
title = "Art Exhibition Attendance\n(Daily Visitors)"
sublabel = "Week 1"
textlabel = "10 Visitors"
hlines = [135, 125]
ylim = [70, 160]
yticks = [70, 90, 110, 130, 150]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified dimensions
fig, ax = plt.subplots(figsize=(8, 6))

# Create the boxplots with custom colors
colors = ['#1f77b4', '#2ca02c']  # Blue and Green
bp1 = ax.boxplot(
    data1, positions=[1], widths=0.6, patch_artist=True, 
    boxprops=dict(facecolor=colors[0], alpha=0.6),
    medianprops=dict(color='black')
)
bp2 = ax.boxplot(
    data2, positions=[2], widths=0.6, patch_artist=True,
    boxprops=dict(facecolor=colors[1], alpha=0.6),
    medianprops=dict(color='black')
)

# Set the labels for the x-axis
ax.set_xticklabels(xticklabels, ha="center")

# Set the labels for the y-axis and x-axis
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)

# Set the y-axis limits and ticks
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a custom annotation for the 10 visitors difference
ax.annotate(
    "",
    xy=(2.25, 135),
    xytext=(2.25, 125),
    arrowprops=dict(facecolor="black", arrowstyle="->"),
    horizontalalignment="center",
)

# Add the text for the 10 visitors difference
ax.text(2.5, 130, textlabel, horizontalalignment="center")

# Add the dashed line for the 10 visitors difference
ax.hlines(hlines[0], 1, 2.25, colors="grey", linestyles="dashed")
ax.hlines(hlines[1], 2, 2.25, colors="grey", linestyles="dashed")

# Add the title and subtitle
fig.suptitle(title)
fig.text(0.5, 0.94, sublabel, ha='center', fontsize=12, color='grey')

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("box_57.pdf", bbox_inches="tight")

