
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for the boxplots (average monthly rainfall in mm for two regions)
data1 = [120, 135, 110, 145, 130, 125, 140]
data2 = [95, 100, 90, 85, 105, 110, 95]

# Label configurations
xticklabels = ["Region A", "Region B"]
xlabel = "Regions"
ylabel = "Average Monthly Rainfall (mm)"
xlim = [0.5, 3]
ylim = [50, 200]
yticks = [50, 75, 100, 125, 150, 175, 200]
textlabel = "Difference in Rainfall"
hlines = [145, 85]
title = "Comparison of Average Monthly Rainfall Between Two Regions"
legendlabels = ["Region A", "Region B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified dimensions
fig, ax = plt.subplots(figsize=(6, 4))

# Create the boxplots with custom colors
bp1 = ax.boxplot(
    data1, positions=[1], widths=0.6, patch_artist=True, 
    boxprops=dict(facecolor="#5DA5DA")
)
bp2 = ax.boxplot(
    data2, positions=[2], widths=0.6, patch_artist=True, 
    boxprops=dict(facecolor="#FAA43A")
)

# Set the labels for the x-axis
ax.set_xticklabels(xticklabels, ha="center")
ax.set_xlim(xlim)

# Set the labels for the y-axis and chart title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Set the y-axis limits and ticks
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a custom annotation for the difference in rainfall
ax.annotate(
    "",
    xy=(2.25, 145),
    xytext=(2.25, 85),
    arrowprops=dict(facecolor="black", arrowstyle="->"),
    horizontalalignment="center",
)

# Add the text for the difference in rainfall
ax.text(2.5, 115, textlabel, horizontalalignment="center")

# Add the dashed line for the difference in rainfall
ax.hlines(hlines[0], 1, 2.25, colors="grey", linestyles="dashed")
ax.hlines(hlines[1], 2, 2.25, colors="grey", linestyles="dashed")

# Add a legend
ax.legend([bp1["boxes"][0], bp2["boxes"][0]], legendlabels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.tight_layout()
plt.savefig("box_58.pdf", bbox_inches="tight")
