

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data for the boxplots (synthetic data for weights of individuals in different age groups)
data = [
    np.random.normal(30, 5, size=100),   # Age Group 1 (10-20 years)
    np.random.normal(55, 10, size=100),  # Age Group 2 (21-30 years)
    np.random.normal(70, 15, size=100),  # Age Group 3 (31-40 years)
    np.random.normal(80, 12, size=100),  # Age Group 4 (41-50 years)
    np.random.normal(75, 10, size=100),  # Age Group 5 (51-60 years)
]

# Age group names for the x-axis
categories = [
    "10-20 years",
    "21-30 years",
    "31-40 years",
    "41-50 years",
    "51-60 years",
]

# Axes Limits and Labels
xticks_values = range(1, len(categories) + 1)
ylim_values = [20, 130]
yticks_values = list(range(20, 140, 10))
yticks_label = [str(i) for i in yticks_values]
ylabel_value = "Weight (kg)"
xlabel_value = "Age Groups"
title_value = "Weights by Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
plt.figure(figsize=(10, 8))  # Size in inches
boxprops = dict(linestyle='-', linewidth=2, color='black')
medianprops = dict(color='red', linewidth=2)
meanpointprops = dict(marker='D', markeredgecolor='black', markerfacecolor='firebrick')

plt.boxplot(data, boxprops=boxprops, medianprops=medianprops, meanline=False, showmeans=True, meanprops=meanpointprops,
            patch_artist=True, notch=True)

# Set the x-axis labels and title
plt.xticks(xticks_values, categories, fontsize=12)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_label)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)

# Adding grid for better readability
plt.grid(which='both', linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_59.pdf", bbox_inches="tight")

