# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generated sample data for art style ratings (0 to 10) for different styles
data = [
    [6.8, 7.0, 7.2, 7.5, 7.7],
    [5.5, 6.7, 6.9, 7.1, 7.3],
    [8.0, 8.2, 8.5, 8.7, 8.9],
    [4.2, 4.5, 4.8, 5.0, 5.2],
    [7.1, 7.3, 7.5, 7.8, 8.0],
]

# Category names for the x-axis
categories = [
    "Abstract",
    "Realism",
    "Impressionism",
    "Cubism",
    "Surrealism",
]

# Axes Limits and Labels
xticks_values = range(1, len(categories) + 1)
ylim_values = [0, 10]
yticks_values = range(0, 11)
yticks_label = [str(i) for i in range(0, 11)]
ylabel_value = "Art Style Ratings (0-10)"
title = "Customer Ratings for Art Styles"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
plt.figure(figsize=(10, 7))  # Adjusted size for better readability
plt.boxplot(
    data,
    medianprops=dict(color="darkgreen"),
    boxprops=dict(color="blue", linewidth=2),
    whiskerprops=dict(color="blue", linewidth=1.5),
    capprops=dict(color="blue", linewidth=1.5),
)

# Set the x-axis labels
plt.xticks(xticks_values, categories, fontweight="bold")
plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_label)
# Set the y-axis label
plt.ylabel(ylabel_value, fontsize=12, fontweight="bold")

# Add a title
plt.title(title, fontsize=14, fontweight="bold")

# Enhance grid appearance
plt.grid(True, linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_60.pdf", bbox_inches="tight")
