

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for the number of significant historical events (by era)
data = [
    np.random.normal(15, 3, 100),  # Ancient
    np.random.normal(12, 4, 100),  # Medieval
    np.random.normal(20, 5, 100),  # Renaissance
    np.random.normal(25, 7, 100),  # Industrial
    np.random.normal(30, 6, 100),  # Modern
]

# Era names for the x-axis
categories = [
    "Ancient",
    "Medieval",
    "Renaissance",
    "Industrial",
    "Modern",
]

# Axes Limits and Labels
xticks_values = range(1, len(categories) + 1)
ylim_values = [0, 50]
yticks_values = range(0, 51, 5)
yticks_label = [str(i) for i in yticks_values]
ylabel_value = "Number of Events"

xlabel_value = "Historical Eras"
title_value = "Significant Historical Events Across Eras"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))  # Increased size for better readability

# Create the boxplot with optimized style
boxprops = dict(linestyle='-', linewidth=3, color='blue')
medianprops = dict(color='red', linewidth=2)
whiskerprops = dict(linestyle='--', linewidth=2, color='purple')
capprops = dict(color='green', linewidth=2)
flierprops = dict(marker='o', color='green', alpha=0.5)

plt.boxplot(data, notch=True, boxprops=boxprops, medianprops=medianprops,
            whiskerprops=whiskerprops, capprops=capprops, flierprops=flierprops)

# Set the x-axis labels
plt.xticks(xticks_values, categories, fontsize=12)
plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_label, fontsize=12)

# Set the x-axis and y-axis labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)

# Add grid for better readability
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_61.pdf", bbox_inches="tight")

