

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# New sample data for history domain
# Annual average population growth rates (mean, std deviation)
data = [
    np.random.normal(0.2, 0.1, 100),  # Ancient period
    np.random.normal(0.5, 0.2, 100),  # Medieval period
    np.random.normal(0.8, 0.3, 100),  # Renaissance period
    np.random.normal(1.1, 0.4, 100),  # Industrial period
    np.random.normal(1.5, 0.5, 100)   # Modern period
]

labels = ["Ancient", "Medieval", "Renaissance", "Industrial", "Modern"]
ylabel = "Population Growth Rate (%)"
xlabel = "Historical Period"
title = "Population Growth Rates Across Different Historical Periods"
ylim = [0, 2]
yticks = np.arange(0, 2.1, 0.2)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for the box plot, using a calm and soothing palette
box_colors = ["#8FAADC", "#AED581", "#FFCDD2", "#FFF59D", "#CE93D8"]

# Create the boxplot
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size as per the new dimensions
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(color="black"),
    medianprops=dict(color="black"),
    whiskerprops=dict(color="black", linestyle="-"),
    capprops=dict(color="black", linestyle="-"),
)

# Coloring each box
for patch, color in zip(bp["boxes"], box_colors):
    patch.set_facecolor(color)

# Set outliers styles
for flier in bp["fliers"]:
    flier.set(marker='o', color='black', alpha=0.5)

# Set the y-axis range and tick labels
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Set the y-axis label, x-axis label, and title
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')

# Adjust the tick label size
ax.tick_params(axis="both", which="major", labelsize=10)
plt.xticks(rotation=0)

# Grid styling
ax.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("box_63.pdf", bbox_inches="tight")

