

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data representing stress levels for different occupational groups
data = [
    np.random.normal(55, 10, 100),  # Healthcare Workers
    np.random.normal(50, 15, 100),  # Teachers
    np.random.normal(45, 20, 100),  # Software Engineers
    np.random.normal(60, 10, 100),  # Sales Representatives
    np.random.normal(50, 15, 100)   # Managers
]

labels = ["Healthcare Workers", "Teachers", "Software Engineers", "Sales Representatives", "Managers"]
ylabel = "Stress Level"
xlabel = "Occupational Groups"
title = "Occupational Stress Levels"
ylim = [0, 100]
yticks = np.arange(0, 101, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(
    figsize=(8, 6)
)
color_scheme = ["#d4a373", "#8cb369", "#fc6f03", "#f4a259", "#f2bc94"]

bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(color="black"),
    medianprops=dict(color="red"),
    whiskerprops=dict(color="black", linestyle="--"),
    capprops=dict(color="black", linestyle="--")
)

# Color the boxes
for patch, color in zip(bp['boxes'], color_scheme):
    patch.set_facecolor(color)

# Remove outliers
for flier in bp["fliers"]:
    flier.set(marker="", color="black")

# Set the y-axis range and tick labels
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Set the axis labels and title
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Set the tick label size
ax.tick_params(axis="both", which="major", labelsize=10)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("box_64.pdf", bbox_inches="tight")

