
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for societal domain: Income Levels and Education Levels
income_levels = [
    np.random.normal(50000, 5000, 100),
    np.random.normal(60000, 6000, 100),
    np.random.normal(55000, 4000, 100),
]
education_levels = [
    np.random.normal(70, 4, 100),
    np.random.normal(75, 5, 100),
    np.random.normal(72, 3, 100),
]

# Labels and titles for the societal data
titles = ["Income Levels", "Education Levels"]
xticklabels = ["Group A", "Group B", "Group C"]
ylabels = ["Income ($)", "Education Level (%)"]
yticks = [np.arange(40000, 70000, 5000), np.arange(60, 81, 5)]
ylims = [[40000, 70000], [60, 80]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots with specified figure size
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))
medianprops = dict(linestyle="-", linewidth=1.5, color="darkblue")
# Left subplot - Income Levels
bplot1 = ax1.boxplot(
    income_levels,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="darkblue", markerfacecolor="darkblue", markersize=6),
)
ax1.set_title(titles[0])
ax1.set_xticklabels(xticklabels)
ax1.set_ylabel(ylabels[0])
ax1.set_yticks(yticks[0])
ax1.set_ylim(ylims[0])
ax1.set_facecolor("#f0f0f5")
ax1.yaxis.grid(True, color="white")

# Add median value annotations
for i, line in enumerate(bplot1["medians"]):
    x, y = line.get_xydata()[1]
    ax1.text(x-0.3, y + 500, f"{y:.2f}", horizontalalignment="center", color="darkblue")

# Right subplot - Education Levels
bplot2 = ax2.boxplot(
    education_levels,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="darkblue", markerfacecolor="darkblue", markersize=6),
)
ax2.set_title(titles[1])
ax2.set_xticklabels(xticklabels)
ax2.set_ylabel(ylabels[1])
ax2.set_yticks(yticks[1])
ax2.set_ylim(ylims[1])
ax2.set_facecolor("#f0f0f5")
ax2.yaxis.grid(True, color="white")

# Add median value annotations
for i, line in enumerate(bplot2["medians"]):
    x, y = line.get_xydata()[1]
    ax2.text(x-0.3, y + 0.3, f"{y:.2f}", horizontalalignment="center", color="darkblue")

# Set colors for boxplots
colors = ["#ff9999", "#66b3ff", "#99ff99"]
for bplot in (bplot1, bplot2):
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_66.pdf", bbox_inches="tight")
