
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New environmental science data (e.g., average monthly rainfall in different regions)
data = {
    "Average Monthly Rainfall (mm)": np.random.rand(6, 6) * 200 + 50,
}

# Text labels and yticks
labels = [
    "Region A",
    "Region B",
    "Region C",
    "Region D",
    "Region E",
    "Region F",
]

# Axis limits
xlim = [50, 250]

# Chart titles and labels
title = "Average Monthly Rainfall Across Regions"
xlabel = "Rainfall (mm)"
ylabel = "Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(5, 5), constrained_layout=True)
colors = ["#88d8b0", "#68a691", "#4f8a8b", "#c1e1c1", "#7a9e7e", "#b0c4de"]

bplot = ax.boxplot(
    data["Average Monthly Rainfall (mm)"],
    vert=False,
    patch_artist=True,
    showcaps=False,
    showfliers=False,
    whiskerprops=dict(color="black", linestyle="--", linewidth=1.5),
    medianprops={"color": "red", "linewidth": 2},
    boxprops=dict(linestyle="-", linewidth=1.5),
)
for patch, color in zip(bplot["boxes"], colors):
    patch.set_facecolor(color)

# Set axis labels and titles
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Set yticks and axis limits
ax.set_yticklabels(labels)
ax.set_xlim(xlim)

# Style adjustments
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.xaxis.grid(True, alpha=0.7, linestyle='--')
ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_72.pdf", bbox_inches="tight")
