
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)  # Setting a seed for reproducibility

# Sample data for "Average Sleep Duration" (in hours)
data = {
    "Average Sleep Duration": np.random.rand(6, 6) * 4 + 4,  # Adjusting the range to be [4, 8] hours
}

labels = [
    "Children (0-12)",
    "Teens (13-19)",
    "Young Adults (20-35)",
    "Adults (36-55)",
    "Seniors (56-75)",
    "Elderly (76+)",
]
xlim = [4, 8]

# Chart text label parameters
xlabel = "Sleep Duration (hours)"
ylabel = "Age Group"
title = "Comparison of Average Sleep Durations Among Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), constrained_layout=True)
# Color scheme reflecting age groups
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

bplot = ax.boxplot(
    data["Average Sleep Duration"],
    vert=False,
    patch_artist=True,
    showcaps=False,
    showfliers=False,
    whiskerprops=dict(color="black", linestyle="--", linewidth=1.5),
    medianprops={"color": "yellow", "linewidth": 2},
    boxprops=dict(linestyle="-", linewidth=1.5),
)

# Apply colors to box plots
for patch, color in zip(bplot["boxes"], colors):
    patch.set_facecolor(color)

# Title and labels
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Y-tick labels
ax.set_yticklabels(labels, fontsize=10)

# Set x-axis limits
ax.set_xlim(xlim)

# Hide unnecessary spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)

# Grid settings
ax.xaxis.grid(True, linestyle='--', alpha=0.7)
ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_73.pdf", bbox_inches="tight")
