

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Social Media Platforms
platforms = [
    "Facebook",
    "Instagram",
    "Twitter",
    "LinkedIn",
    "Snapchat",
    "Pinterest",
    "Reddit",
    "TikTok",
    "YouTube",
    "WhatsApp",
][::-1]

# Generate random engagement scores for each platform, assuming 10 different tests
scores = [np.random.uniform(200, 800, 10) for _ in range(len(platforms) * 2)]
# Normalize the scores between 0 and 1
scores = [(score - np.min(score)) / (np.max(score) - np.min(score)) for score in scores]

# Labels and limits
xlabels = ["Individual Tests", "Combined Tests"]
ylims = [[0, 11], [0, 11]]
xlims = [[-0.05, 1.05], [-0.05, 1.05]]
yticks = [range(1, len(platforms) + 1), range(1, len(platforms) + 1)]

# Plot text parameters
xtitle = "Engagement Score"
suptitle = "Social Media Engagement Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure and Axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6), sharey=True)
medianprops = dict(linestyle="-", linewidth=2, color="black")
colors = [
    "#2c7bb6",
    "#abd9e9",
    "#ffffbf",
    "#fee090",
    "#fdae61",
    "#f46d43",
    "#d73027",
    "#d7191c",
    "#a50026",
    "#313695",
][::-1]
backcolors = ["#e0f3f8", "#d0d1e6", "#dfc27d", "#f6e8c3"][::-1]

# Subplot 1: Individual Tests
bplot1 = ax1.boxplot(
    scores[:10], vert=False, medianprops=medianprops, patch_artist=True
)
ax1.set_ylim(ylims[0])
ax1.set_yticks(yticks[0])
ax1.set_yticklabels(platforms)
ax1.set_xlim(xlims[0])
ax1.set_xlabel(xlabels[0])
ax1.set_facecolor("#F0F8FF")
ax1.xaxis.grid(True)
ax1.set_axisbelow(True)

for patch, color in zip(bplot1["boxes"], colors):
    patch.set_facecolor(color)

# Set background colors
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 0.5), 1.1, 1.5, facecolor=backcolors[0], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 1.5), 1.1, 1.5, facecolor=backcolors[1], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 2.5), 1.1, 5.5, facecolor=backcolors[2], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 7.5), 1.1, 3, facecolor=backcolors[3], edgecolor="none", zorder=0
    )
)

# Subplot 2: Combined Tests
bplot2 = ax2.boxplot(
    scores[10:], vert=False, medianprops=medianprops, patch_artist=True
)
ax2.set_ylim(ylims[1])
ax2.set_yticks(yticks[1])
ax2.set_yticklabels(platforms)
ax2.set_xlim(xlims[1])
ax2.set_xlabel(xlabels[1])
ax2.set_facecolor("#F0F8FF")
ax2.xaxis.grid(True)
ax2.set_axisbelow(True)

for patch, color in zip(bplot2["boxes"], colors):
    patch.set_facecolor(color)

# Set background colors
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 0.5), 1.1, 1.5, facecolor=backcolors[0], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 1.5), 1.1, 1.5, facecolor=backcolors[1], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 2.5), 1.1, 5.5, facecolor=backcolors[2], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 7.5), 1.1, 3, facecolor=backcolors[3], edgecolor="none", zorder=0
    )
)

# Set a unified title for the figure
plt.suptitle(suptitle)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("box_77.pdf", bbox_inches="tight")

