
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data: Philosophy - The Impact of Philosophers on Different Fields
philosophers = [
    "Plato", 
    "Aristotle", 
    "Descartes", 
    "Kant", 
    "Nietzsche", 
    "Hegel", 
    "Marx", 
    "Socrates", 
    "Confucius", 
    "Aquinas"
][::-1]
impacts = [
    np.random.uniform(50, 100, 10) for _ in philosophers * 2
]
impacts = [(impact - np.min(impact)) / (np.max(impact) - np.min(impact)) for impact in impacts]

# Text Labels
xlabels = ["Ethics", "Metaphysics"]
ylimits = [[0, 11], [0, 11]]
xlimits = [[-0.05, 1.05], [-0.05, 1.05]]
yticks = [range(1, len(philosophers) + 1), range(1, len(philosophers) + 1)]

# Chart Titles and Labels
xlabel1 = "Impact on Ethics"
xlabel2 = "Impact on Metaphysics"
title = "Impact of Philosophers on Various Fields"

# Colors for the plot
box_colors = [
    "#8c564b",
    "#e377c2",
    "#7f7f7f",
    "#bcbd22",
    "#17becf",
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd",
][::-1]
background_colors = ["#c7eae5", "#f6e8c3", "#fddbc7", "#e5f5e0"][::-1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure and Axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6), sharey=True)
medianprops = dict(linestyle="-", linewidth=2, color="black")

# Subplot 1: Ethics
bplot1 = ax1.boxplot(
    impacts[:10], vert=False, medianprops=medianprops, patch_artist=True
)
ax1.set_ylim(ylimits[0])
ax1.set_yticks(yticks[0])
ax1.set_yticklabels(philosophers)
ax1.set_xlim(xlimits[0])
ax1.set_xlabel(xlabel1)
ax1.set_facecolor("#f7f7f7")
ax1.xaxis.grid(True)
ax1.set_axisbelow(True)

# Customize colors
for patch, color in zip(bplot1["boxes"], box_colors):
    patch.set_facecolor(color)

# Set background colors
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 0.5), 1.1, 1.5, facecolor=background_colors[0], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 1.5), 1.1, 1.5, facecolor=background_colors[1], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 2.5), 1.1, 5.5, facecolor=background_colors[2], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 7.5), 1.1, 3, facecolor=background_colors[3], edgecolor="none", zorder=0
    )
)

# Subplot 2: Metaphysics
bplot2 = ax2.boxplot(
    impacts[10:], vert=False, medianprops=medianprops, patch_artist=True
)
ax2.set_ylim(ylimits[1])
ax2.set_yticks(yticks[1])
ax2.set_yticklabels(philosophers)
ax2.set_xlim(xlimits[1])
ax2.set_xlabel(xlabel2)
ax2.set_facecolor("#f7f7f7")
ax2.xaxis.grid(True)
ax2.set_axisbelow(True)

for patch, color in zip(bplot2["boxes"], box_colors):
    patch.set_facecolor(color)

# Set background colors
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 0.5), 1.1, 1.5, facecolor=background_colors[0], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 1.5), 1.1, 1.5, facecolor=background_colors[1], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 2.5), 1.1, 5.5, facecolor=background_colors[2], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 7.5), 1.1, 3, facecolor=background_colors[3], edgecolor="none", zorder=0
    )
)

# Titles and Layout
fig.suptitle(title, fontsize=14)
plt.tight_layout()
plt.subplots_adjust(top=0.9)

# ===================
# Part 4: Saving Output
# ===================
# Save the figure
plt.savefig("box_79.pdf", bbox_inches="tight")
