

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Placeholder data for the boxplots - Tech product performance metrics
data1 = [np.random.normal(3, 0.5, 100), np.random.normal(2.8, 0.4, 100)]  # Startup Time (seconds)
data2 = [np.random.normal(200, 30, 100), np.random.normal(180, 25, 100)]  # Execution Speed (ms)
data3 = [np.random.normal(50, 8, 100), np.random.normal(45, 7, 100)]  # Battery Usage (mAh)
data4 = [np.random.normal(400, 50, 100), np.random.normal(380, 45, 100)]  # Memory Usage (MB)
data5 = [np.random.normal(100, 20, 100), np.random.normal(90, 25, 100)]  # Network Latency (ms)
titles = [
    "Startup Time",
    "Execution Speed",
    "Battery Usage",
    "Memory Usage",
    "Network Latency",
]
xticklabels = ["Version A", "Version B"]
xticks = [1, 2]
xlabel = "Product Version"
ylabels = (
    "Time (seconds)",
    "Time (ms)",
    "Usage (mAh)",
    "Usage (MB)",
    "Time (ms)",
)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot colors
colors = ["#4c72b0", "#55a868"]

# Create a figure with custom dimensions
fig, axs = plt.subplots(1, 5, figsize=(15, 5))  # Adjusted for clarity

# Plot the boxplots with the specified colors and outlier shapes
for i, data in enumerate([data1, data2, data3, data4, data5]):
    bplot = axs[i].boxplot(
        data,
        patch_artist=True,
        notch=False,
        widths=0.7,
        medianprops=dict(color="black"),
        flierprops=dict(
            marker="o", color="black", markerfacecolor="red", markersize=5
        ),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)
        patch.set_alpha(0.7)

# Set the titles for each subplot
for i, ax in enumerate(axs):
    ax.set_title(titles[i])
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)
    ax.grid(True, linestyle='--', alpha=0.6)

# Set the y-axis labels
for i, ylabel in enumerate(ylabels):
    axs[i].set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("box_83.pdf", bbox_inches="tight")
