
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)

# Placeholder data for the boxplots (Educational Data)
data1 = [np.random.normal(75, 10, 100), np.random.normal(80, 10, 100)]  # Subject Scores
data2 = [np.random.normal(90, 5, 100), np.random.normal(85, 5, 100)]  # Attendance Rates
data3 = [np.random.normal(50, 15, 100), np.random.normal(55, 15, 100)]  # Sports Participation
data4 = [np.random.normal(30, 10, 100), np.random.normal(35, 10, 100)]  # Library Visits
data5 = [np.random.normal(70, 12, 100), np.random.normal(65, 12, 100)]  # Art Class Participation

titles = [
    "Subject Scores Distribution",
    "Attendance Rates",
    "Sports Participation",
    "Library Visits",
    "Art Class Participation",
]
xticklabels = ["School A", "School B"]
xticks = [1, 2]
xlabel = "School"
ylabels = (
    "Scores",
    "Attendance Rates (%)",
    "Participation (%)",
    "Visits per Year",
    "Participation (%)",
)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom dimensions to match the original image
fig, axs = plt.subplots(1, 5, figsize=(15, 5))  # Adjusted for clarity

# Define colors for the boxplots
colors = ["#4682B4", "#32CD32"]

# Plot the boxplots with the specified colors and outlier shapes
for i, data in enumerate([data1, data2, data3, data4, data5]):
    bplot = axs[i].boxplot(
        data,
        patch_artist=True,
        notch=False,
        widths=0.7,
        medianprops=dict(color="black"),
        flierprops=dict(
            marker="o", color="red", markerfacecolor="red", markersize=5
        ),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# Set the titles for each subplot
axs[0].set_title(titles[0])
axs[1].set_title(titles[1])
axs[2].set_title(titles[2])
axs[3].set_title(titles[3])
axs[4].set_title(titles[4])

# Set the x-axis labels with proper spacing
for ax in axs:
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)

# Set the y-axis labels
axs[0].set_ylabel(ylabels[0])
axs[1].set_ylabel(ylabels[1])
axs[2].set_ylabel(ylabels[2])
axs[3].set_ylabel(ylabels[3])
axs[4].set_ylabel(ylabels[4])

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("box_84.pdf", bbox_inches="tight")
