

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for stock performance in different sectors
data = {
    "Technology": np.random.uniform(5, 20, 100),
    "Healthcare": np.random.uniform(2, 18, 100),
    "Finance": np.random.uniform(-5, 10, 100),
    "Consumer Goods": np.random.uniform(0, 15, 100),
}

# Reverse the order of data for boxplots
data_values = list(data.values())[::-1]
data_keys = list(data.keys())[::-1]
xlabel = "Stock Performance (%)"
xlim = [-10, 25]
xticks = np.arange(-10, 26, 5)
title = "Stock Performance across Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(9, 5))

# Create the boxplots with specific colors
boxprops = dict(linestyle="-", linewidth=2, color="black")
flierprops = dict(marker="*", color="black", markersize=5)
medianprops = dict(linestyle="-", linewidth=2, color="black")

bp = ax.boxplot(
    data_values,
    vert=False,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
)

# New color palette: soft and business-like
colors = ["#ffcc5c", "#96ceb4", "#ff6f69", "#ffccbb"][::-1]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Set the y-axis labels with reversed order
ax.set_yticklabels(data_keys)

# Set the x-axis label
ax.set_xlabel(xlabel)

# Set the x-axis limits and ticks
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.set_xticklabels(["{}%".format(i) for i in xticks])

# Set the title of the plot
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_87.pdf", bbox_inches="tight")

