

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data (entertainment domain: box office earnings of movies with different budgets)
data = [
    np.random.normal(30, 5, 100),  # Budget < $10M
    np.random.normal(50, 10, 100),  # Budget $10-30M
    np.random.normal(70, 15, 100),  # Budget $30-50M
    np.random.normal(90, 20, 100),  # Budget $50-100M
    np.random.normal(120, 25, 100),  # Budget > $100M
]

labels = ["< $10M", "$10-30M", "$30-50M", "$50-100M", "> $100M"]

# Axes Limits and Labels
ylim_values = [10, 150]
xlabel_value = "Movie Budget (Million Dollars)"
ylabel_value = "Box Office Earnings (Million Dollars)"
title = "Effect of Movie Budgets on Box Office Earnings"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(facecolor="#66c2a5", color="black"),
    showfliers=False,
    showcaps=False,
    medianprops=dict(color="black"),
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    capprops=dict(color="black", linestyle="-"),
)

# Set individual box colors
colors = ["#fee08b", "#fdae61", "#f46d43", "#d73027", "#a50026"]
for patch, color in zip(bp['boxes'], colors):
    patch.set_facecolor(color)

# Set labels and title
ax.set_ylim(ylim_values)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)

# Set grid
ax.grid(True, linestyle='--', linewidth=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_91.pdf", bbox_inches="tight")
