

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the boxplots
data = {
    "Low Income": np.random.uniform(20000, 40000, 20),
    "Middle Income": np.random.uniform(40000, 80000, 20),
    "High Income": np.random.uniform(80000, 150000, 20),
    "Very High Income": np.random.uniform(150000, 300000, 20),
}
ylabel = "Annual Income (in $)"
title = "Income Levels in Different Neighborhoods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(9, 5))

# Create the boxplots with specific colors
boxprops = dict(linestyle="-", linewidth=2, color="darkgreen")
flierprops = dict(marker="o", color="purple", markerfacecolor="purple", markersize=5)
medianprops = dict(linestyle="--", linewidth=2, color="#ff5733")

# Boxplot with vertical orientation
bp = ax.boxplot(
    data.values(),
    vert=True,
    notch=True,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
)

colors = ["#a2d5c6", "#74b49b", "#f4b6c2", "#ffadad"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Set the x-axis labels with data keys
ax.set_xticklabels(data.keys(), ha="center")

# Set the y-axis label
ax.set_ylabel(ylabel)

# Disable x-axis grid and enable y-axis grid for clarity
ax.xaxis.grid(False)
ax.yaxis.grid(True)

# Set the title of the plot
ax.set_title(title, fontsize=14)

# Annotating medians inside the boxplots
for i, line in enumerate(bp["medians"]):
    x, y = line.get_xydata()[1]  # Top of the median line
    # Display the median value at the top of the median line
    ax.annotate(
        f"{y:.1f}", (x - 0.1, y), textcoords="offset points", xytext=(0, 5), ha="center"
    )

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_93.pdf", bbox_inches="tight")

