
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample financial data
data = {
    "Revenue (million $)": np.random.rand(6, 6) * 100 + 50,
    "Profit Margin (%)": np.random.rand(6, 6) * 20 + 5,
    "Expenses (million $)": np.random.rand(6, 6) * 80 + 30,
    "Growth Rate (%)": np.random.rand(6, 6) * 15 + 1,
}

# Financial quarters
labels = [
    "Q1 2020",
    "Q2 2020",
    "Q3 2020",
    "Q4 2020",
    "Q1 2021",
    "Q2 2021",
]

# Titles and labels
xlabel = "Financial Quarters"
ylabel = {
    "Revenue (million $)": "Revenue (million $)",
    "Profit Margin (%)": "Profit Margin (%)",
    "Expenses (million $)": "Expenses (million $)",
    "Growth Rate (%)": "Growth Rate (%)",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8c564b", "#e377c2", "#7f7f7f", "#bcbd22", "#17becf", "#1f77b4"]

fig, axes = plt.subplots(2, 2, figsize=(10, 10), constrained_layout=True)

for i, (ax, (metric, values)) in enumerate(zip(axes.flatten(), data.items())):
    bplot = ax.boxplot(
        values,
        vert=True,
        patch_artist=True,
        showcaps=False,
        showfliers=False,
        whiskerprops=dict(color="gray", linestyle="--", linewidth=1),
        medianprops={"color": "red", "linewidth": 2},
        boxprops=dict(linestyle="-", linewidth=1.5),
    )
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)
    ax.set_title(metric)
    ax.set_ylabel(ylabel[metric])
    if i == 2 or i == 3:
        ax.set_xticklabels(labels, rotation=45)
    else:
        ax.set_xticks([])
    ax.yaxis.grid(True, alpha=0.7)
    ax.xaxis.grid(False)
    ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_95.pdf", bbox_inches="tight")
