

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for educational test scores
data1 = [
    np.random.normal(75, std, 50)
    for std in np.random.uniform(5, 15, 5)
]
data2 = [
    np.random.normal(70, std, 50)
    for std in np.random.uniform(5, 15, 5)
]
data3 = [
    np.random.normal(80, std, 50)
    for std in np.random.uniform(5, 15, 5)
]

labels = [
    "Institution A",
    "Institution B",
    "Institution C",
    "Low Score Threshold",
    "High Score Threshold"
]

vlines = [60, 90]
xlim = [40, 110]
ylabel = "Test Scores"
xlabel = "Different Test Categories"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Boxplot
fig, ax = plt.subplots(figsize=(12, 8))  # Adjust figure size
bp1 = ax.boxplot(
    data1,
    positions=np.array(range(len(data1))) * 2.0 - 0.4,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)
bp2 = ax.boxplot(
    data2,
    positions=np.array(range(len(data2))) * 2.0,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)
bp3 = ax.boxplot(
    data3,
    positions=np.array(range(len(data3))) * 2.0 + 0.4,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)

# New colors for the boxplots
new_colors = ["#ff9999", "#66b3ff", "#99ff99"]

# Set properties for each boxplot
for bp, color in zip([bp1, bp2, bp3], new_colors):
    for patch in bp["boxes"]:
        patch.set_facecolor(color)
    for whisker in bp["whiskers"]:
        whisker.set(color="black", linewidth=1)
    for cap in bp["caps"]:
        cap.set(color="black", linewidth=1)
    for median in bp["medians"]:
        median.set(color="black", linewidth=2)

# Add dashed line for thresholds
ax.axvline(
    x=vlines[0], color="#d62728", linestyle="--", linewidth=1.5, label=labels[3]
)
ax.axvline(
    x=vlines[1], color="#2ca02c", linestyle="--", linewidth=1.5, label=labels[4]
)

# Add legend with updated colors and markers
legend_elements = [
    mpatches.Patch(color="#ff9999", label=labels[0]),
    mpatches.Patch(color="#66b3ff", label=labels[1]),
    mpatches.Patch(color="#99ff99", label=labels[2]),
    mlines.Line2D([], [], color="#d62728", linestyle="--", label=labels[3]),
    mlines.Line2D([], [], color="#2ca02c", linestyle="--", label=labels[4]),
]

# Place legend outside the plot area
ax.legend(
    handles=legend_elements,
    loc="upper center",
    bbox_to_anchor=(0.5, -0.15),
    ncol=3,
    frameon=False,
)

# Set y-axis labels and limits
ax.set_xlim(xlim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)

# Set y-axis tick positions and labels
ax.set_yticks(range(0, len(data1) * 2, 2))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_99.pdf", bbox_inches="tight")

