

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import multivariate_normal
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data generation for temperature and humidity distributions
x = np.linspace(-50, 50, 400)
y = np.linspace(-50, 50, 400)
X, Y = np.meshgrid(x, y)
pos = np.dstack((X, Y))
rv1 = multivariate_normal([10, 20], [[100, 10], [10, 100]])
rv2 = multivariate_normal([-10, -20], [[150, -10], [-10, 150]])
Z1 = rv1.pdf(pos)
Z2 = rv2.pdf(pos)
title = "Temperature and Humidity Distribution"
xlabel = "Longitude"
ylabel = "Latitude"
labels = ["Temperature Region", "Humidity Region"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))
contour1 = plt.contourf(X, Y, Z1, cmap="Greens", alpha=0.7)
contour2 = plt.contourf(X, Y, Z2, cmap="Oranges", alpha=0.5)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Create legend with color patches
legend_patches = [
    Patch(color="#2e8b57", label=labels[0]),  # dark green
    Patch(color="#ff8c00", label=labels[1]),  # dark orange
]
plt.legend(handles=legend_patches)

# Adjust plot to match the original image's dimensions
plt.gca().set_aspect("equal", adjustable="box")

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_23.pdf", bbox_inches="tight")

