

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
x = np.linspace(-180, 180, 100)  # Longitude range
y = np.linspace(-90, 90, 100)    # Latitude range
X, Y = np.meshgrid(x, y)
Z = 1000 * np.sin(np.radians(Y)) * np.cos(np.radians(X / 2))  # Elevation data

# Labels and Titles
xlabel = 'Longitude (degrees)'
ylabel = 'Latitude (degrees)'
title = 'Topographic Elevation'
legendlabels = ['Elevation Levels']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Contour
fig, ax = plt.subplots(figsize=(8, 8))
cnt = ax.contour(X, Y, Z, cmap="inferno", linewidths=1.5, linestyles='dashed')
ax.clabel(cnt, cnt.levels, inline=True, fontsize=10)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_31.pdf", bbox_inches="tight")
