

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate synthetic data for contour plots
x = np.linspace(-5, 5, 400)
y = np.linspace(-5, 5, 400)
X, Y = np.meshgrid(x, y)

# Define two data surfaces for two regions
Z_high_connectivity = np.exp(-2 * (X**2 + Y**2))  # Gaussian bump for High Connectivity area
Z_low_connectivity = np.exp(-2 * ((X - 2) ** 2 + (Y + 2) ** 2))  # Gaussian bump for Low Connectivity area

# Plot configuration variables
title = "Contour Plot of Signal Strength and Connectivity Quality"
labels = ["High Connectivity Area", "Low Connectivity Area"]
xlabel = "X Coordinate"
ylabel = "Y Coordinate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))
contour_high = plt.contour(X, Y, Z_high_connectivity, colors="blue", linestyles="-", linewidths=2)
contour_low = plt.contour(X, Y, Z_low_connectivity, colors="orange", linestyles="--", linewidths=2)
plt.contourf(X, Y, Z_high_connectivity, alpha=0.3, cmap="Blues")
plt.contourf(X, Y, Z_low_connectivity, alpha=0.3, cmap="Oranges")
plt.title(title)

# Adding labels and legend
legend_patches = [
    Patch(color="blue", label=labels[0], alpha=0.3),
    Patch(color="orange", label=labels[1], alpha=0.3),
]
plt.legend(handles=legend_patches)

# Customizing the plot appearance
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.grid(True, linestyle="-.", alpha=0.6)
plt.axhline(0, color="black", linewidth=0.5)
plt.axvline(0, color="black", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_37.pdf", bbox_inches="tight")
