

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generating sample data for stress and relaxation zones
x = np.linspace(-100, 100, 400)
y = np.linspace(-100, 100, 400)
X, Y = np.meshgrid(x, y)
pos = np.dstack((X, Y))

# Stress and relaxation areas modeled using bivariate Gaussian functions
Z1 = np.exp(-0.01 * ((X - 30) ** 2 + (Y - 30) ** 2))  # Stress Zone
Z2 = np.exp(-0.01 * ((X + 30) ** 2 + (Y + 30) ** 2))  # Relaxation Zone

# Titles and labels
title = "Stress and Relaxation Zones"
labels = ["Stress Zone", "Relaxation Zone"]
xlabel = "Longitude"
ylabel = "Latitude"
legend_location = "upper right"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))

# Plot Stress Zone area
contour1 = plt.contourf(
    X, Y, Z1, cmap="Blues", alpha=0.6
)

# Plot Relaxation Zone area
contour2 = plt.contourf(
    X, Y, Z2, cmap="Greens", alpha=0.6
)

# Set plot title and legend
plt.title(title, fontsize=16)

# Create legend with color patches
legend_patches = [
    Patch(color="blue", label=labels[0], alpha=0.6),
    Patch(color="green", label=labels[1], alpha=0.6),
]
plt.legend(handles=legend_patches, fontsize=12, loc=legend_location)

# Set equal aspect ratio for the plot
plt.gca().set_aspect("equal", adjustable="box")

# Axis labels
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# Add gridlines for better readability
plt.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Reduce whitespace around the plot
plt.savefig("contour_42.pdf", bbox_inches="tight")

