

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generating sample data for wireless signal analysis
x = np.linspace(-10, 10, 400)
y = np.linspace(-10, 10, 400)
X, Y = np.meshgrid(x, y)
pos = np.dstack((X, Y))

# Wireless signal data modeled using bivariate Gaussian functions
signal_strength = np.exp(-0.5 * ((X - 2) ** 2 + (Y - 2) ** 2))
device_density = np.exp(-0.5 * ((X + 3) ** 2 + (Y + 3) ** 2))

# Titles and labels
title = "Wireless Network Analysis"
labels = ["Signal Strength", "Device Density"]
xlabel = "Distance (km)"
ylabel = "Distance (km)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper right"
plt.figure(figsize=(10, 6))

# Plot Signal Strength
contour1 = plt.contourf(
    X, Y, signal_strength, cmap="Greens", alpha=0.6
)  

# Plot Device Density
contour2 = plt.contourf(
    X, Y, device_density, cmap="Blues", alpha=0.6
)  

# Set plot title and legend
plt.title(title, fontsize=16)

# Create legend with color patches
legend_patches = [
    Patch(color="green", label=labels[0], alpha=0.6),
    Patch(color="blue", label=labels[1], alpha=0.6),
]
plt.legend(handles=legend_patches, fontsize=12, loc=legend_location)

# Set equal aspect ratio for the plot
plt.gca().set_aspect("equal", adjustable="box")

# Axis labels
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Reduce whitespace around the plot
plt.savefig("contour_44.pdf", bbox_inches="tight")

