
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data generation for Financial Transaction Density Distribution
x = np.linspace(-50, 50, 500)
y = np.linspace(-50, 50, 500)
X, Y = np.meshgrid(x, y)

# Define Gaussian Functions for data representation
def gaussian(x, y, x0, y0, sx, sy):
    return np.exp(-(((x - x0) ** 2) / (2 * sx**2) + ((y - y0) ** 2) / (2 * sy**2)))

# Generate data
Z1 = gaussian(X, Y, -10, 20, 5, 10)  # ATM Withdrawals
Z2 = gaussian(X, Y, 30, -30, 15, 20) # Bank Deposits
Z3 = gaussian(X, Y, -20, -10, 20, 25) # Online Payments

# Chart titles and labels
title = "Financial Transaction Density Distribution in the City"
xlabel = "Longitude"
ylabel = "Latitude"
labels = ["ATM Withdrawals", "Bank Deposits", "Online Payments"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_fontsize = 12
title_fontsize = 16
label_fontsize = 14

# Plotting
plt.figure(figsize=(12, 8))

# ATM Withdrawals: Green solid lines
contour1 = plt.contourf(X, Y, Z1, cmap="Greens", alpha=0.6)
plt.contour(X, Y, Z1, colors='green', linewidths=1)

# Bank Deposits: Red dashed lines
contour2 = plt.contourf(X, Y, Z2, cmap="Reds", alpha=0.4)
plt.contour(X, Y, Z2, colors='red', linewidths=1, linestyles='dashed')

# Online Payments: Blue dotted lines
contour3 = plt.contourf(X, Y, Z3, cmap="Blues", alpha=0.3)
plt.contour(X, Y, Z3, colors='blue', linewidths=1, linestyles='dotted')

# Title and labels
plt.title(title, fontsize=title_fontsize)
plt.xlabel(xlabel, fontsize=label_fontsize)
plt.ylabel(ylabel, fontsize=label_fontsize)

# Create legend with color patches
legend_patches = [
    Patch(color="green", label=labels[0]),
    Patch(color="red", label=labels[1]),
    Patch(color="blue", label=labels[2]),
]
plt.legend(handles=legend_patches, fontsize=legend_fontsize)

# Additional plot adjustments
plt.gca().set_aspect("equal", adjustable="box")
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_46.pdf", bbox_inches="tight")
