
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(49)
# Create a grid of longitude and latitude values
longitude = np.linspace(-10, 10, 200)
latitude = np.linspace(-10, 10, 200)
X, Y = np.meshgrid(longitude, latitude)

# Adjust the lambda function to reflect temperature distribution in a region
def temperature_distribution_function(X, Y):
    return (
        np.exp(-((X - 3) ** 2 + (Y - 3) ** 2) / 3) * 30  # Peak at (3,3)
        + np.exp(-((X + 4) ** 2 + (Y - 4) ** 2) / 4) * 25  # Peak at (-4,-4)
        + np.exp(-((X) ** 2 + (Y + 5) ** 2) / 2) * 20  # Peak at (0,-5)
    )

# Calculate the function values on the grid
Z = temperature_distribution_function(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Temperature Distribution"
colorbar_label = "Temperature (°C)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a custom colormap
n_colors = 10  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("viridis", n_colors)

contour = plt.contourf(X, Y, Z, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(Z.min(), Z.max(), n_colors))
cbar.set_label(colorbar_label)

# Label the axes
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)

# Style adjustments
plt.grid(True, linestyle="--", alpha=0.7)  # Add a grid for better readability
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_49.pdf", bbox_inches="tight")
