

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a grid of x (latitude) and z (longitude) values
np.random.seed(52)  # Different seed for different data
x = np.linspace(0, 50, 120)
z = np.linspace(0, 50, 120)
X, Z = np.meshgrid(x, z)

# Define the soil moisture function with different peaks
def soil_moisture_function(X, Z):
    return (
        np.exp(-((X - 10) ** 2 + (Z - 15) ** 2) / 20)
        + np.exp(-((X - 30) ** 2 + (Z - 35) ** 2) / 30)
        + np.exp(-((X - 45) ** 2 + (Z - 20) ** 2) / 25)
    )

# Calculate the function values on the grid
Z_values = soil_moisture_function(X, Z)

# Label parameters
xlabel = "Latitude (normalized)"
ylabel = "Longitude (normalized)"
title = "Soil Moisture Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a color scheme that represents soil moisture (green to brown)
n_colors = 12  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("RdYlGn_r", n_colors)

contour = plt.contourf(X, Z, Z_values, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(
    contour, ticks=np.linspace(Z_values.min(), Z_values.max(), n_colors)
)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_52.pdf", bbox_inches="tight")

