
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Create a new set of grid for temperature and pollution over time
days = np.linspace(0, 365, 100)
regions = np.linspace(0, 50, 100)
Days, Regions = np.meshgrid(days, regions)

# Define a new function to simulate temperature and pollution levels
def environmental_data(Days, Regions):
    return 30 + 10 * np.sin(Days / 50) * np.cos(Regions / 5) + 5 * np.sin(Days / 20) * np.cos(Regions / 10)

# Calculate environmental data on the grid
EnvironmentalData = environmental_data(Days, Regions)
xlabel = "Days"
ylabel = "Regions"
title = "Temperature and Pollution Levels Over Time and Regions"
cbar_label = "Environmental Index"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a distinct colormap with "viridis"
n_levels = 20
cmap = plt.cm.viridis

contour = plt.contourf(Days, Regions, EnvironmentalData, levels=n_levels, cmap=cmap)
plt.contour(Days, Regions, EnvironmentalData, levels=n_levels, colors="white", linewidths=0.5)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_56.pdf", bbox_inches="tight")
