
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define court dimensions (meters)
court_length = np.linspace(0, 28, 100)
court_width = np.linspace(0, 15, 100)
Court_Length, Court_Width = np.meshgrid(court_length, court_width)

# Function simulating player density distribution on the basketball court
def player_density_distribution(Court_Length, Court_Width):
    # Simulating density with higher values in common areas: paint, perimeter, and three-point line
    paint = np.exp(-((Court_Length - 14) ** 2 + (Court_Width - 7.5) ** 2) / 10)
    perimeter = np.exp(-((Court_Length - 22) ** 2 + (Court_Width - 7.5) ** 2) / 15)
    three_point_line = np.exp(-((Court_Length - 6) ** 2 + (Court_Width - 7.5) ** 2) / 20)
    return paint + perimeter + three_point_line

# Calculate the density values on the grid
Density = player_density_distribution(Court_Length, Court_Width)
xlabel = "Court Length (meters)"
ylabel = "Court Width (meters)"
title = "Player Density Distribution on Basketball Court"
cbar_label = "Player Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a colormap suitable for density data
cmap = plt.cm.get_cmap("Spectral")

contour = plt.contourf(Court_Length, Court_Width, Density, levels=25, cmap=cmap)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Enhance grid lines for better readability
plt.grid(True, linestyle="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_58.pdf", bbox_inches="tight")
