
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a grid of x and y values representing soil moisture levels in different regions
x = np.linspace(0, 100, 100)
y = np.linspace(0, 100, 100)
X, Y = np.meshgrid(x, y)

# Function representing the soil moisture level influenced by different factors
def soil_moisture_distribution(X, Y):
    return np.sin(np.sqrt(X**2 + Y**2)/10) * np.exp(-0.01 * X) + 0.5 * np.sin(0.1 * Y)

# Calculate the function values on the grid
Z_values = soil_moisture_distribution(X, Y)
xlabel = "Spatial Location X (meters)"
ylabel = "Spatial Location Y (meters)"
title = "Soil Moisture Level Distribution"
cbar_label = "Soil Moisture Level (vol %)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(8, 6))

# Using a colormap suitable for soil moisture level data visualization
cmap = plt.cm.get_cmap("viridis")

contour = plt.contourf(X, Y, Z_values, levels=25, cmap=cmap)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Enhance grid lines for better readability
plt.grid(True, linestyle="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_59.pdf", bbox_inches="tight")
