

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate data for an art and design domain
x = np.linspace(-10, 10, 150)
y = np.linspace(-10, 10, 150)
X, Y = np.meshgrid(x, y)

# Art gallery density (Field A) and Art enthusiast density (Field B)
Z1 = np.exp(-((X-2)**2 + (Y-2)**2)/10)  # Art gallery density
Z2 = np.exp(-((X+2)**2 + (Y+2)**2)/10)  # Art enthusiast density

labels = ["Art Gallery Density", "Art Enthusiast Density"]
xlabel = "City Coordinates (X)"
ylabel = "City Coordinates (Y)"
title = "Art and Design Field Distribution"
cbar_label = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(12, 9))

# Contour lines for Art Gallery Density (cool colors) and Art Enthusiast Density (warm colors)
CS1 = ax.contour(X, Y, Z1, colors="blue", linestyles="solid", linewidths=1.5)
CS2 = ax.contour(X, Y, Z2, colors="orange", linestyles="dashed", linewidths=2)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=15)
ax.set_ylabel(ylabel, fontsize=15)
ax.set_title(title, fontsize=18)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=13)

# Set the aspect of the plot
ax.set_aspect("equal")
ax.grid(True)
ax.set_facecolor("#f5f5f5")
ax.set_ylim(-10, 10)
ax.set_xlim(-10, 10)

# Add color bar to represent field density
field_density = ax.contourf(X, Y, Z1 + Z2, alpha=0.3, cmap="coolwarm")
cbar = fig.colorbar(field_density, ax=ax)
cbar.set_label(cbar_label, fontsize=13)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_64.pdf", bbox_inches="tight")

