
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Sample data to create popularity distribution of music genres
x = np.linspace(-20, 20, 200)
y = np.linspace(-20, 20, 200)
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 5) ** 2 + (Y - 5) ** 2) / 10)
Z2 = np.exp(-((X + 8) ** 2 + (Y + 8) ** 2) / 10)

# Labels and texts
labels = ["Genre A", "Genre B"]
xlabel = "Geographic Temporality X"
ylabel = "Geographic Temporality Y"
title = "Popularity Distribution of Music Genres"
colorbar_label = "Popularity Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_fontsize = 13
xlabel_fontsize = 15
ylabel_fontsize = 15
title_fontsize = 18
colorbar_fontsize = 14

# Create the plot
fig, ax = plt.subplots(figsize=(12, 9))

# Contour lines for Genre A (purple) and Genre B (blue)
CS1 = ax.contour(X, Y, Z1, colors="purple", linestyles="dotted", linewidths=2)
CS2 = ax.contour(X, Y, Z2, colors="blue", linestyles="dashdot", linewidths=2)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=xlabel_fontsize)
ax.set_ylabel(ylabel, fontsize=ylabel_fontsize)
ax.set_title(title, fontsize=title_fontsize)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=legend_fontsize)

# Set the aspect of the plot
ax.set_aspect("equal")
ax.grid(True)
ax.set_facecolor("#f0f0f0")
ax.set_ylim(-20, 20)
ax.set_xlim(-20, 20)

# Add color bar to represent popularity intensity
popularity_intensity = ax.contourf(X, Y, Z1 + Z2, alpha=0.5, cmap="plasma")
cbar = fig.colorbar(popularity_intensity, ax=ax)
cbar.set_label(colorbar_label, fontsize=colorbar_fontsize)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_67.pdf", bbox_inches="tight")

