
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data: Simulate voter turnout rates over a geographical region
import numpy as np

np.random.seed(42)
X, Y = np.meshgrid(np.linspace(-5, 5, 300), np.linspace(-5, 5, 300))

# Simulate varying voter turnout distribution
Z1 = np.sin(X) * np.cos(Y)
Z2 = np.exp(-(X**2 + Y**2) / 20)
Z = Z1 * Z2

# Extracted strings
title_text = "Voter Turnout Distribution"
xlabel_text = "Geographical Longitude"
ylabel_text = "Geographical Latitude"
colorbar_label_text = "Voter Turnout Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Filled contour with custom colormap
fig, ax = plt.subplots(figsize=(10, 8))
cnt = ax.contour(X, Y, Z, levels=15, colors="gray", linestyles='dashed', linewidths=0.8)
ax.clabel(cnt, cnt.levels, inline=True, fontsize=8, fmt="%.2f")
contour_filled = ax.contourf(X, Y, Z, levels=15, cmap="coolwarm")

# Title and Labels
ax.set_title(title_text, fontsize=16, fontweight='bold')
ax.set_xlabel(xlabel_text, fontsize=14)
ax.set_ylabel(ylabel_text, fontsize=14)
cbar = fig.colorbar(contour_filled, ax=ax)
cbar.set_label(colorbar_label_text, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_72.pdf", bbox_inches="tight")
