
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt  # Importing the plotting library

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Create some new data for a communication domain
distance = np.linspace(0, 20, 100)
signal_strength = np.exp(-0.2 * distance)
interference = 0.3 * np.sin(0.5 * distance) + 0.5

# Label parameters
xlabel = 'Distance (km)'
ylabel = 'Signal Value'
title = 'Signal Strength and Interference vs Distance'
legend_labels = ['Signal Strength', 'Interference']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for better visibility

# Plot the data with optimized color scheme and style
ax.fill_between(signal_strength, distance, color="skyblue", edgecolor="#4682b4", alpha=0.7, label=legend_labels[0])
ax.fill_between(interference, distance, color="lightgreen", edgecolor="#32cd32", alpha=0.5, label=legend_labels[1])

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=False, labelbottom=False)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim(0, 1)  # Adjusted xlim based on the data range
ax.set_ylim(0, 20)  # Preserving the original ylim for consistency

# Add a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_24.pdf", bbox_inches="tight")

