
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

from scipy.stats import gaussian_kde

# Generate a bimodal distribution for AQI
aqi_urban_areas = np.random.normal(loc=120, scale=30, size=500)
aqi_rural_areas = np.random.normal(loc=50, scale=20, size=500)
air_quality_index = np.concatenate([aqi_urban_areas, aqi_rural_areas])
xs = np.linspace(0, 300, 200)

# Axes Limits and Labels
xticks_values = [0, 50, 100, 150, 200, 250, 300]
xticklabels = ["0", "50", "100", "150", "200", "250", "300"]
yticks_values = [0, 0.005, 0.01, 0.015, 0.02]
yticklabels = ["0.00", "0.005", "0.01", "0.015", "0.02"]
xlim_values = [0, 300]
ylim_values = [0, 0.02]
title = "KDE Plot of Air Quality Index Distribution"
xlabel_value = "Air Quality Index (AQI)"
ylabel_value = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to be more prominent
fig, ax = plt.subplots(figsize=(10, 6))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(air_quality_index)
density.covariance_factor = lambda: 0.5
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#6a0dad", edgecolor="#ffd700", linewidth=2, alpha=0.7)

# Set grid lines for clarity
plt.grid(True, linestyle='--', alpha=0.6)

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Set the title and labels
plt.title(title, fontsize=16, fontweight='bold')
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_27.pdf", bbox_inches="tight")
