

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Using a different seed for variability
from scipy.stats import gaussian_kde

# Generate tourism data for two regions
data_region_A = np.random.normal(loc=6, scale=1.5, size=500)  # Peak around June
data_region_B = np.random.normal(loc=10, scale=1.5, size=500)  # Peak around October
data = np.concatenate([data_region_A, data_region_B])
xs = np.linspace(0, 12, 200)  # Representing months from 0 to 12

# Axes Limits and Labels
xticks_values = [0, 2, 4, 6, 8, 10, 12]
xticklabels = ["Jan", "Mar", "May", "Jul", "Sep", "Nov", "Dec"]
yticks_values = [0, 0.05, 0.10, 0.15, 0.20]
yticklabels = ["0.0", "0.05", "0.10", "0.15", "0.20"]
xlim_values = [0, 12]
ylim_values = [0, 0.20]
title = "KDE Plot of Tourist Visits Distribution"
xlabel_value = "Months"
ylabel_value = "Density of Visits"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(9, 5))
color_fill = "#a6cee3"
color_edge = "#1f78b4"

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(data)
density.covariance_factor = lambda: 0.3
density._compute_covariance()
plt.fill_between(xs, density(xs), color=color_fill, edgecolor=color_edge, linewidth=2)

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)
# Set the title and labels
plt.title(title)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_28.pdf", bbox_inches="tight")
