
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for three modes of transport
travel_times_car = np.random.normal(loc=30, scale=10, size=1000)
travel_times_bike = np.random.normal(loc=20, scale=5, size=1000)
travel_times_train = np.random.normal(loc=25, scale=7, size=1000)
labels = ["Car", "Bike", "Train"]
xlabel = "Travel Time (minutes)"
ylabel = "Density"
title = "Travel Time Distributions for Different Modes of Transport"
avxlabel = "Average Travel Time"
reserved_temp = 25  # Example of an average travel time line

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Plot the density plots
for data, color, label in zip(
    [travel_times_car, travel_times_bike, travel_times_train],
    ["#1f77b4", "#2ca02c", "#ff7f0e"],  # Blue, Green, Orange
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(0, 60, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.5, label=label)

# Plot the average travel time line
plt.axvline(x=reserved_temp, color="black", linestyle="--", label=avxlabel)

# Set labels and title
ax.set_xlim(0, 60)
ax.set_xticks(np.arange(0, 61, 10))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid with custom styling
plt.grid(True, linestyle="--", alpha=0.7)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_32.pdf", bbox_inches="tight")
