
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
# Simulate stock prices for two different companies over a period of time
prices_company_1 = np.random.normal(150, 25, 300)
prices_company_2 = np.random.normal(300, 50, 300)

# Combine data for density estimation
price_data_1 = prices_company_1
price_data_2 = prices_company_2

# Kernel Density Estimation (KDE) for the stock price data
kde_prices_1 = gaussian_kde(price_data_1, bw_method='scott')
kde_prices_2 = gaussian_kde(price_data_2, bw_method='scott')

x_dens_prices = np.linspace(min(min(price_data_1), min(price_data_2)), 
                            max(max(price_data_1), max(price_data_2)), 1000)
density_prices_1 = kde_prices_1(x_dens_prices)
density_prices_2 = kde_prices_2(x_dens_prices)

# Extracted variables for the density plot
xlabel_text = "Stock Prices ($)"
ylabel_text = "Density"
title_text = "Density of Stock Prices for Different Companies"

label=["Company 1 Density", "Company 2 Density"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the density curves for stock price data
ax.plot(x_dens_prices, density_prices_1, color='red', lw=2, label=label[0])
ax.fill_between(x_dens_prices, density_prices_1, color='red', alpha=0.3)

ax.plot(x_dens_prices, density_prices_2, color='blue', lw=2, label=label[1])
ax.fill_between(x_dens_prices, density_prices_2, color='blue', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_47.pdf", bbox_inches="tight")
