# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(49)
# Simulated monthly ticket sales data for three movie genres
sales_action = np.random.normal(500, 80, 300)
sales_comedy = np.random.normal(450, 70, 300)
sales_drama = np.random.normal(550, 90, 300)

# Combine data for density estimation
sales_data_1 = sales_action
sales_data_2 = sales_comedy
sales_data_3 = sales_drama

# Kernel Density Estimation (KDE) for the movie ticket sales data
kde_sales_1 = gaussian_kde(sales_data_1, bw_method="scott")
kde_sales_2 = gaussian_kde(sales_data_2, bw_method="scott")
kde_sales_3 = gaussian_kde(sales_data_3, bw_method="scott")

x_dens_sales = np.linspace(
    min(min(sales_data_1), min(sales_data_2), min(sales_data_3)),
    max(max(sales_data_1), max(sales_data_2), max(sales_data_3)),
    1000,
)
density_sales_1 = kde_sales_1(x_dens_sales)
density_sales_2 = kde_sales_2(x_dens_sales)
density_sales_3 = kde_sales_3(x_dens_sales)

# Extracted variables for the density plot
xlabel_text = "Monthly Movie Ticket Sales"
ylabel_text = "Density"
title_text = "Density of Monthly Movie Ticket Sales for Different Genres"

labels = ["Action Genre Density", "Comedy Genre Density", "Drama Genre Density"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the density curves for movie ticket sales data
ax.plot(x_dens_sales, density_sales_1, color="red", lw=2, label=labels[0])
ax.fill_between(x_dens_sales, density_sales_1, color="red", alpha=0.3)

ax.plot(x_dens_sales, density_sales_2, color="blue", lw=2, label=labels[1])
ax.fill_between(x_dens_sales, density_sales_2, color="blue", alpha=0.3)

ax.plot(x_dens_sales, density_sales_3, color="green", lw=2, label=labels[2])
ax.fill_between(x_dens_sales, density_sales_3, color="green", alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_49.pdf", bbox_inches="tight")
