
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(51)
# Generating new data representing signal strength
signal_strength_city_a = np.random.normal(loc=70, scale=15, size=1000)
signal_strength_city_b = np.random.normal(loc=55, scale=20, size=1000)

# Extracted strings
title_text = "Density Distribution of Signal Strength Measurements"
xlabel_text = "Signal Strength (dBm)"
ylabel_text = "Density"
legend_label1 = "City A Signal Strength"
legend_label2 = "City B Signal Strength"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(12, 7))  # Adjusted for better readability

# Adding a line for the true distribution (assuming normal for illustration)
x = np.linspace(min(signal_strength_city_a.min(), signal_strength_city_b.min()), max(signal_strength_city_a.max(), signal_strength_city_b.max()), 300)
color_city_a = "forestgreen"
color_city_b = "royalblue"
city_a_pdf = (1 / (np.sqrt(2 * np.pi) * 15)) * np.exp(-((x - 70) ** 2) / (2 * 15**2))
city_b_pdf = (1 / (np.sqrt(2 * np.pi) * 20)) * np.exp(-((x - 55) ** 2) / (2 * 20**2))
ax.plot(x, city_a_pdf, linestyle="--", linewidth=2, color=color_city_a, label=legend_label1)
ax.plot(x, city_b_pdf, linestyle="--", linewidth=2, color=color_city_b, label=legend_label2)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)

# Add title and labels
ax.set_title(title_text, fontsize=18)
ax.set_xlabel(xlabel_text, fontsize=16)
ax.set_ylabel(ylabel_text, fontsize=16)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_51.pdf", bbox_inches="tight")
