
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde
np.random.seed(42)  # For reproducibility

# Simulate stock prices over 24 trading hours
time = np.linspace(0, 24, 100)
stock_price_1 = 100 + 20 * np.sin(2 * np.pi * time / 24) + np.random.normal(0, 5, size=time.shape)
stock_price_2 = 120 + 15 * np.cos(2 * np.pi * time / 24) + np.random.normal(0, 5, size=time.shape)

# Combine data for density estimation
price_data = np.concatenate((stock_price_1, stock_price_2))

# Kernel Density Estimation (KDE) for the stock price data
kde_price = gaussian_kde(price_data, bw_method='scott')
x_dens_price = np.linspace(min(price_data), max(price_data), 1000)
density_price = kde_price(x_dens_price)

# Extracted variables for the density plot
xlabel_text = "Stock Price ($)"
ylabel_text = "Density"
title_text = "Density of Stock Prices over 24 Trading Hours"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the density curve for stock prices
ax.plot(x_dens_price, density_price, color='green', lw=2, label='Price Density')
ax.fill_between(x_dens_price, density_price, color='green', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_54.pdf", bbox_inches="tight")
