# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
subjects = ["Math", "Science", "English", "History"]
scores = [np.random.normal(loc=70 + i * 5, scale=10, size=300) for i in range(4)]

# Combine all subject scores data for density estimation
all_scores = np.concatenate(scores)

# Kernel Density Estimation (KDE) for the scores data
kde_scores = gaussian_kde(all_scores, bw_method="scott")
x_dens_scores = np.linspace(min(all_scores), max(all_scores), 1000)
density_scores = kde_scores(x_dens_scores)

# Extracted variables for the density plot
xlabel_text = "Scores"
ylabel_text = "Density"
title_text = "Density of Student Scores Across Different Subjects"

label = "Scores Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Define colors
plot_color = "blue"
fill_color = "blue"

# Plot the density curve for scores
ax.plot(x_dens_scores, density_scores, color=plot_color, lw=2, label=label)
ax.fill_between(x_dens_scores, density_scores, color=fill_color, alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_55.pdf", bbox_inches="tight")
