

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Create philosophy data
years = np.linspace(1900, 2020, 100)  # Years from 1900 to 2020
existentialism_adoption = 0.7 * np.exp(-0.003 * (years - 1950) ** 2)
pragmatism_interest = 0.6 * (1 / (1 + np.exp(-0.02 * (years - 1980))))

# Text variables
xlabel_text = "Year"
ylabel_text = "Proportion of Philosophical Interest"
title_text = "Trends in Philosophy: Existentialism vs. Pragmatism"
legend_existentialism = "Adoption of Existentialism"
legend_pragmatism = "Interest in Pragmatism"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper left"
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data
ax.fill_between(
    years,
    existentialism_adoption,
    color="#66c2a5",
    edgecolor="#1b7837",
    alpha=0.6,
    label=legend_existentialism,
)
ax.fill_between(
    years,
    pragmatism_interest,
    color="#3288bd",
    edgecolor="#08519c",
    alpha=0.6,
    label=legend_pragmatism,
)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)
ax.set_ylim(0, 1)
ax.grid(True, which='both', linestyle='--', linewidth=0.5, color='gray', alpha=0.7)

# Add legend
ax.legend(loc=legend_location, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_59.pdf", bbox_inches="tight")

