
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Set random seed for reproducibility
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(63)

# Generate sample data for athlete scores and fitness test durations
athlete_scores = np.random.normal(loc=75, scale=15, size=500)
fitness_test_duration = np.random.normal(loc=50, scale=12, size=300)
performance_data = np.concatenate([athlete_scores, fitness_test_duration])
xs = np.linspace(0, 150, 300)

# Axes Limits and Labels
title = "KDE Plot of Athlete Performance Metrics"
xlabel_value = "Performance Metrics (scores or fitness test duration in minutes)"
ylabel_value = "Density"

xticks_values = [0, 25, 50, 75, 100, 125, 150]
xticklabels = ["0", "25", "50", "75", "100", "125", "150"]
yticks_values = [0, 0.005, 0.01, 0.015, 0.02, 0.025, 0.03]
yticklabels = ["0.0", "0.005", "0.01", "0.015", "0.02", "0.025", "0.03"]
xlim_values = [0, 150]
ylim_values = [0, 0.03]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Set the figure size
fig, ax = plt.subplots(figsize=(12, 6))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(performance_data)
density.covariance_factor = lambda: 0.20
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#b0e0e6", edgecolor="#4682b4")

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Set the title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_63.pdf", bbox_inches="tight")
