
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(123)

# Generate new sample data for monthly electricity consumption of different household types (in kWh)
consumption_small_apartments = np.random.normal(loc=350, scale=100, size=1000)  # Small apartments
consumption_medium_houses = np.random.normal(loc=600, scale=150, size=1000)  # Medium-sized houses
consumption_large_houses = np.random.normal(loc=900, scale=200, size=1000)  # Large houses

# Labels for the new data
labels = ["Small Apartments", "Medium-sized Houses", "Large Houses"]
avxlabel = "Average Monthly Consumption"
xlabel = "Electricity Consumption (kWh per month)"
ylabel = "Density"
title = "Monthly Electricity Consumption by Household Type"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Define colors for the different household types
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot the density plots
for data, color, label in zip(
    [consumption_small_apartments, consumption_medium_houses, consumption_large_houses], colors, labels
):
    density = gaussian_kde(data)
    xs = np.linspace(0, 1400, 200)
    density.covariance_factor = lambda: 0.4
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the average electricity consumption line
plt.axvline(x=616.67, color="purple", linestyle="--", linewidth=2, label=avxlabel)

# Set chart labels and title
ax.set_xlim(0, 1400)
ax.set_xticks(np.arange(0, 1500, 100))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
plt.title(title)

# Show grid
plt.grid(True, linestyle="--", alpha=0.6)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_69.pdf", bbox_inches="tight")
