

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(123)

# Generate new sample data for annual hotel booking rates in different regions
booking_rate_urban = np.random.normal(loc=80, scale=10, size=1000)  # Urban region
booking_rate_suburban = np.random.normal(loc=70, scale=15, size=1000)  # Suburban region
booking_rate_rural = np.random.normal(loc=60, scale=20, size=1000)  # Rural region

# Labels for the new data
labels = ["Urban", "Suburban", "Rural"]
avxlabel = "Average Booking Rate"
xlabel = "Booking Rate (%)"
ylabel = "Density"
title = "Annual Hotel Booking Rates by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Define colors for the different regions
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot the density plots
for data, color, label in zip(
    [booking_rate_urban, booking_rate_suburban, booking_rate_rural], colors, labels
):
    density = gaussian_kde(data)
    xs = np.linspace(20, 100, 200)
    density.covariance_factor = lambda: 0.4
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.5, label=label)

# Plot the average booking rate line
plt.axvline(x=70, color="red", linestyle="--", linewidth=1.5, label=avxlabel)

# Set chart labels and title
ax.set_xlim(20, 100)
ax.set_xticks(np.arange(20, 101, 10))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
plt.title(title)

# Show grid
plt.grid(True, linestyle="--", alpha=0.6)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_70.pdf", bbox_inches="tight")

