

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(72)
# Sample data for crop yields (in bushels per acre)
wheat_yields = np.random.normal(loc=60, scale=10, size=1500)
corn_yields = np.random.normal(loc=150, scale=20, size=1500)
rice_yields = np.random.normal(loc=100, scale=15, size=1500)
labels = ["Wheat Yields", "Corn Yields", "Rice Yields"]
avxlabel = "Target Yield"
xlabel = "Yield (Bushels per Acre)"
ylabel = "Density"
title = "Density Plot of Crop Yields Across Different Crops"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Plot the density plots
for data, color, label in zip(
    [wheat_yields, corn_yields, rice_yields],
    ["#2ca02c", "#ff7f0e", "#1f77b4"],  # Green, Orange, Blue
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(20, 200, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the target yield line
plt.axvline(x=100.0, color="red", linestyle="--", label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(20, 200)
ax.set_xticks(
    [20, 40, 60, 80, 100, 120, 140, 160, 180, 200]
)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--", linewidth=0.7)

# Add legend
plt.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_72.pdf", bbox_inches="tight")

