

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(73)
# Sample data for athlete performance under different training regimens
cardio = np.random.normal(loc=55, scale=8, size=1500)
strength_training = np.random.normal(loc=65, scale=9, size=1500)
flexibility = np.random.normal(loc=50, scale=7, size=1500)
labels = ["Cardio", "Strength Training", "Flexibility"]
avxlabel = "Optimal Performance Threshold"
xlabel = "Performance Score"
ylabel = "Density"
title = "Density Plot of Athlete Performance Across Training Regimens"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the density plots
for data, color, label in zip(
    [cardio, strength_training, flexibility],
    ["#ff7f0e", "#2ca02c", "#d62728"],  # Modern tech theme colors
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(30.0, 90.0, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.4, label=label)

# Plot the optimal threshold line
plt.axvline(x=60, color="purple", linestyle="--", linewidth=2, label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(30.0, 90.0)
ax.set_xticks(range(30, 91, 5))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--", alpha=0.6)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_73.pdf", bbox_inches="tight")

